// -----------------------------------------------------------------------------
// Project:	TToolbarEditor
// Module:	tbeadd - Add/Import menu items at design time
// -----------------------------------------------------------------------------
unit tbeadd;

// -----------------------------------------------------------------------------
//
//			Interface
//
// -----------------------------------------------------------------------------
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  ComCtrls, StdCtrls, ExtCtrls, Menus, Buttons,
  tbedit;

type
  TFormDesignToolAdd = class(TForm)
    PanelButtons: TPanel;
    PanelTree: TPanel;
    TreeViewMenu: TTreeView;
    ImageListMenu: TImageList;
    ImageListMenuState: TImageList;
    PopupMenu: TPopupMenu;
    MenuItemSelectAll: TMenuItem;
    MenuItemClearAll: TMenuItem;
    N1: TMenuItem;
    MenuItemFullExpand: TMenuItem;
    MenuItemFullCollapse: TMenuItem;
    ButtonOK: TBitBtn;
    ButtonCancel: TBitBtn;
    procedure ButtonOKClick(Sender: TObject);
    procedure TreeViewMenuMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MenuItemSelectAllClick(Sender: TObject);
    procedure MenuItemClearAllClick(Sender: TObject);
    procedure MenuItemFullExpandClick(Sender: TObject);
    procedure MenuItemFullCollapseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Component: TToolbarEditor;
    procedure importMenuTree;
  end;

// -----------------------------------------------------------------------------
//
//			Implementation
//
// -----------------------------------------------------------------------------
implementation

uses
  dsgnwnds,
  tbedsgn;

//$R *.DFM}

{ Values for StateImage Index }
const
  stUndefined = -1;
  stNotSelected = 1;
  stSelected = 2;


procedure TFormDesignToolAdd.ImportMenuTree;
var
  topNode		: TTreeNode;

  procedure buildTree(topNode: TTreeNode; menuItem: TMenuItem);
  var
    i			: integer;
    subTopNode		: TTreeNode;
  begin
    for i:=0 to menuItem.Count-1 do
    begin
      subTopNode := TreeViewMenu.items.addChildObject(topNode,
        stripShortCut(menuItem.Items[i].caption), menuItem.Items[i]);
      if (menuItem.Items[i].count > 0) then
      begin
        subTopNode.ImageIndex := 1; { Parent node }
        subTopNode.SelectedIndex := 1; { Parent node }
        subTopNode.StateIndex := stNotSelected; { Not selected }
      end else
      begin
        subTopNode.ImageIndex := 2; { End node }
        subTopNode.SelectedIndex := 2; { End node }
        subTopNode.StateIndex := stNotSelected; { Not selected }
      end;
      buildTree(subTopNode, menuItem.Items[i]);
    end;
  end;

begin
  // Import menu items into TreeView
  if (Component.Menu = nil) then
    exit;

  TreeViewMenu.Items.Clear;

  // Insert top node
  topNode := TreeViewMenu.items.add(nil, Component.Menu.name);
  topNode.SelectedIndex := 0; { Top node }
  topNode.ImageIndex := 0; { Top node }
  topNode.StateIndex := stUndefined; { No selection }

  // Build tree recursively
  buildTree(topNode, Component.Menu.Items);

  TreeViewMenu.fullExpand;
  topNode.MakeVisible;
end;

procedure TFormDesignToolAdd.ButtonOKClick(Sender: TObject);
var
  i			: integer;
  j			: integer;
  toolButton		: TToolbarItem;
begin
  ButtonOK.Enabled := False;
  for i:= 0 to TreeViewMenu.Items.Count-1 do
  begin
    if (TreeViewMenu.Items[i].StateIndex = stSelected) then
    begin
      toolButton := TToolbarItem.create(Component);
      toolButton.MenuItem := TreeViewMenu.Items[i].Data;
      toolButton.Category := stripShortCut(toolButton.MenuItem.Parent.Caption);
      toolButton.Description := TreeViewMenu.Items[i].Text;
      if (toNameButtons in Component.Options) then
        toolButton.CreateName
      else
      begin
        j := 1;
        while (j < 1000) do
        begin
          try
            toolButton.Name := 'ToolbarItem'+intToStr(j);
            break;
          except
            inc(j);
          end;
        end;
      end;
      toolButton.hint := toolButton.MenuItem.hint;
      toolButton.enabled := toolButton.MenuItem.enabled;
      toolButton.visible := toolButton.MenuItem.visible;

      Component.Add(toolButton);
    end;
  end;
end;

procedure TFormDesignToolAdd.TreeViewMenuMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (htOnStateIcon in TreeViewMenu.GetHitTestInfoAt(X, Y)) then
  begin
    if (TreeViewMenu.Selected.StateIndex = stNotSelected) then
      TreeViewMenu.Selected.StateIndex := stSelected
    else if (TreeViewMenu.Selected.StateIndex = stSelected) then
      TreeViewMenu.Selected.StateIndex := stNotSelected;
  end;
end;

procedure TFormDesignToolAdd.MenuItemSelectAllClick(Sender: TObject);
var
  i			: integer;
begin
  for i:= 0 to TreeViewMenu.Items.Count-1 do
    if (TreeViewMenu.Items[i].StateIndex = stNotSelected) then
      TreeViewMenu.Items[i].StateIndex := stSelected;
end;

procedure TFormDesignToolAdd.MenuItemClearAllClick(Sender: TObject);
var
  i			: integer;
begin
  for i:= 0 to TreeViewMenu.Items.Count-1 do
    if (TreeViewMenu.Items[i].StateIndex = stSelected) then
      TreeViewMenu.Items[i].StateIndex := stNotSelected;
end;

procedure TFormDesignToolAdd.MenuItemFullExpandClick(Sender: TObject);
begin
  TreeViewMenu.FullExpand;
end;

procedure TFormDesignToolAdd.MenuItemFullCollapseClick(Sender: TObject);
begin
  TreeViewMenu.FullCollapse;
end;

end.
